/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');
require('bootstrap/js/dist/modal');
import VueZxingScanner from "vue-zxing-scanner";
Vue.use(VueZxingScanner);



/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

Vue.component('example-component', require('./components/ExampleComponent.vue').default);

Vue.component('example-component0', require('./components/ExampleComponent0.vue').default);
Vue.component('product-component', require('./components/ProductComponent.vue').default);
Vue.component('enventory-component', require('./components/EnventoryComponent.vue').default);
Vue.component('offer-component', require('./components/OfferComponent.vue').default);
Vue.component('offerpaid-component', require('./components/OfferpaidComponent.vue').default);
Vue.component('supplier-component', require('./components/SupplierComponent.vue').default);
Vue.component('branch-component', require('./components/BranchComponent.vue').default);

Vue.component('account-component', require('./components/AccountComponent.vue').default);

Vue.component('branch-table-component', require('./components/BranchTableComponent.vue').default);

Vue.component('term-component', require('./components/TermComponent.vue').default);


Vue.component('customer-table-component', require('./components/CustomerTableComponent.vue').default);

Vue.component('stock-table-component', require('./components/StockTableComponent.vue').default);

Vue.use(require('vue-shortkey'))

Vue.component('stock-component', require('./components/StockComponent.vue').default);

Vue.component('unit-table', require('./components/UnitTable.vue').default);

Vue.component('daily-entry', require('./components/Daily_Entry.vue').default);

Vue.component('product-table-component', require('./components/ProductTableComponent.vue').default);

Vue.use(require('vue-moment'));

Vue.component('supplier-table-component', require('./components/SupplierTableComponent.vue').default);

Vue.component('offerpaid-table-component', require('./components/TableOfferpaidComponent.vue').default);

Vue.component('offer-table-component', require('./components/TableOfferComponent.vue').default);


Vue.component('supplierorder-table-component', require('./components/TableSupplierorderComponent.vue').default);

Vue.component('supplier-order-component', require('./components/SupplierOrderComponent.vue').default);


Vue.component('pricing-order-component', require('./components/PricingOrderComponent.vue').default);

Vue.component('table-pricing-component', require('./components/TablePricingComponent.vue').default);


Vue.component('create-purchase-component', require('./components/CreatePurchaseComponent.vue').default);

Vue.component('delivery-bond-component', require('./components/DeliveryBondComponent.vue').default);


Vue.component('table-delivery-component', require('./components/TableDeliveryComponent.vue').default);

Vue.component('receipt-component', require('./components/ReceiptsComponent.vue').default);

Vue.component('table-receipt-component', require('./components/TableReceiptComponent.vue').default);


Vue.component('table-account-component', require('./components/TableAccountComponent.vue').default);


Vue.component('table-purchase-component', require('./components/TablePurchaseComponent.vue').default);


Vue.component('unit-component', require('./components/UnitComponent.vue').default);


Vue.component('movements-component', require('./components/MovementsComponent.vue').default);

Vue.component('capital-component', require('./components/CapitalComponent.vue').default);


Vue.component('fixedasset-component', require('./components/FixedassetComponent.vue').default);

Vue.component('withdraw-component', require('./components/WithdrawComponent.vue').default);


Vue.component('profits-component', require('./components/ProfitsComponent.vue').default);


Vue.component('payrollaccounting-component', require('./components/PayrollaccountingComponent.vue').default);



Vue.component('category-component', require('./components/CategoryComponent.vue').default);


Vue.component('category-table', require('./components/CategoryTable.vue').default);

Vue.component('offer-edit-component', require('./components/OffereditComponent.vue').default);



Vue.component('home-component', require('./components/HomeComponent.vue').default);

Vue.component('term-table', require('./components/TermTable.vue').default);



/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

const app = new Vue({
    el: '#app',
  
 
});
