<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\orderpackage;
use Carbon\Carbon;
use App\accountbank;
use App\subaccount1;
use App\sub_account3;
use App\sub_account4;
use App\role;
use App\permession;
class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        $rand_date = Carbon::now();
        $orderpackage =     orderpackage::create([
            'date'=>$rand_date->addWeeks(70)->format('Y-m-d'),
            'code'=>rand(0,1000),
          
          
        ]);
        
        $role = role::find(29);

        $newPost = $role->replicate();
  
        $newPost->created_at = Carbon::now();
        
        $newPost->orderpackage_id = $orderpackage->id;
        
        $newPost->save();
       $permession =  permession::get();
        foreach($permession as $a){
        
            $newPost->permession()->attach($a->id);
        }


  $u =     User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'phone'=>$data['phone'],
            'rep_code'=>$data['rep_code'],
            'password' => Hash::make($data['password']),
            'orderpackage_id'=>$orderpackage->id,
            'role_id'=>$newPost->id,
            'is_banned'=>0
,

'cashier'=>1,
]);

 

     
               $a1    = accountbank::create(   ['name'=>'الاصول',
                'orderpackage_id'=>$orderpackage->id,
                'code'=>1
                ]);
            

                $a2  =  accountbank::create(   ['name'=>'الالتزامات',
                'orderpackage_id'=>$orderpackage->id,
                'code'=>2   
                ]);
                $a5  =  accountbank::create(   ['name'=>' حقوق الملكية',
                'orderpackage_id'=>$orderpackage->id,
                'code'=>3
                ]);

                 


                $a4   =  accountbank::create(   ['name'=>'الايرادات',
                'orderpackage_id'=>$orderpackage->id,
                'code'=>4
                ]);
            
            
                $a3  =  accountbank::create(   ['name'=>'المصروفات',
                'orderpackage_id'=>$orderpackage->id,
                'code'=>5
                ]);
            
                    $b = [
                   
                        [
                            'name'=>'الاصول المتداولة',
                            'code'=>11,
            
                            'account_id'=>$a1->id,
                        ],
            
                        [
                            'name'=>'أصول غير متداولة',
                            'code'=>12,
            
                            'account_id'=>$a1->id,
                        ],
            
            
            
                        [
                            'name'=>'الالتزامات المتداولة',
                            'code'=>21,
            
                            'account_id'=>$a2->id,
                        ],
            
                        [
                            'name'=>'الالتزامات غير المتداولة',
                            'code'=>22,
            
                            'account_id'=>$a2->id,
                        ],
 
              
                        [
                            'name'=>'رأس مال المصدر',
                            'code'=>31,
            
                            'account_id'=>$a5->id,

                        ],

                        [
                            'name'=>'حقوق ملكيه اخري',
                            'code'=>32,
            
                            'account_id'=>$a5->id,

                        ],

                        [
                            'name'=>'احتياطيات',
                            'code'=>33,
            
                            'account_id'=>$a5->id,

                        ],

                        [
                            'name'=>'الأرباح المبقاة',
                            'code'=>34,
            
                            'account_id'=>$a5->id,

                        ],
                  

                 
                        [
                            'name'=>'الإيرادات غير التشغيلية',
                            'code'=>42,
            
                            'account_id'=>$a4->id,
                        ],


                        [
                            'name'=>'الإيرادات التشغيلية',
                            'code'=>41,
            
                            'account_id'=>$a4->id,
                        ],

    
                   
                        [
                            'name'=>'التكاليف المباشرة',
                            'code'=>51,
            
                            'account_id'=>$a3->id,
                        ],


                        [
                            'name'=>'التكاليف التشغيلية',
                            'code'=>52,
            
                            'account_id'=>$a3->id,
                        ],

                    
                        [
                            'name'=>'المصروفات التشغيلية - صناعية',
                            'code'=>53,
            
                            'account_id'=>$a3->id,
                        ],


                        ];



                        //level3
                   $s =     [
//1
                

[


    [
        'name'=>'النقد ومايعادله',
        'code'=>1101,
      
        'sub_account1_id'=>'',

        4=>[


            [

                'name'=>'النقدية في الخزينة',
                'code'=>110101,
              
                'sub_account3_id'=>'',

            ],


            
            [

                'name'=>'العهد النقدية',
                'code'=>110102,
              
                'sub_account3_id'=>'',

            ],

            


        ],
    ],


    [
        'name'=>'النقدية بالبنوك والصندوق',
        'code'=>1102,
      
        'sub_account1_id'=>'',

        4=>[


            [

                'name'=>'حساب البنك الجاري - اسم البنك',
                'code'=>110201,
              
                'sub_account3_id'=>'',

            ],


            


        ],

    ],

    [
        'name'=>'المدينون - العملء',
        'code'=>1103,

        'sub_account1_id'=>'',
    ],


    [
        'name'=>'مصروفات متقدمه',
        'code'=>1104,

        'sub_account1_id'=>'',
        4=>[


            [

                'name'=>'تأمين طبي',
                'code'=>110401,
              
                'sub_account3_id'=>'',

            ],


            
            [

                'name'=>'إيجار مقدم',
                'code'=>110402,
              
                'sub_account3_id'=>'',

            ],

            


        ],

    ],

    [
        'name'=>'مصروفات مقدمه للموظفين',
        'code'=>1105,

        'sub_account1_id'=>'',
    ],

    [
        'name'=>'المخزون',
        'code'=>1106,

        'sub_account1_id'=>'',
    ],




],
               //2
                    [

          
            [
        'name'=>'عقارات و معدات',
        'code'=>1201,

        'sub_account1_id'=>'',

        4=>[


       
            [ 'name'=>'الاراضي',
            'code'=>120101,

            'sub_account3_id'=>''] ,

            [ 'name'=>'المبـــــاني والانشاءات',
            'code'=>120102,

            'sub_account3_id'=>'',] ,

            [ 'name'=>' الالت والمعدات ',
            'code'=>120103,

            'sub_account3_id'=>'',] ,



            [ 'name'=>' أجهزة مكتبية وطابعات',
            'code'=>120104,

            'sub_account3_id'=>'',] ,




            


        ],
        
    ],

    [
        'name'=>'الأصول غير الملموسه',
        'code'=>1202,

        'sub_account1_id'=>'',


    ],

    [
        'name'=>'العقارات الاستثماريه',
        'code'=>1203,

        'sub_account1_id'=>'',
    ],

          
                        
                    ],
//3
                    [


                        [
                            'name'=>'الدائنون',
                            'code'=>2101,
            
                            'sub_account1_id'=>'',

                            
                        ], 
                        [
                            'name'=>'المصروفات المستحقه',
                            'code'=>2102,
            
                            'sub_account1_id'=>'',
                        ], 
    
    
    
                        [
                            'name'=>'الرواتب المستحقه',
                            'code'=>2103,
            
                            'sub_account1_id'=>'',
                        ], 
    
                        [
                            'name'=>'قروض قصيرة الاجل',
                            'code'=>2104,
            
                            'sub_account1_id'=>'',
                        ], 
    
    
                        [
                            'name'=>'ضريبة القيمه المستحقه',
                            'code'=>2105,
            
                            'sub_account1_id'=>'',
                        ], 

                        
                        [
                            'name'=>'الضرائب المستحقه',
                            'code'=>2106,
            
                            'sub_account1_id'=>'',
                        ], 
    
    
                    
                        
                        [
                            'name'=>'ايرادات غير مكتسبه',
                            'code'=>2107,
            
                            'sub_account1_id'=>'',
                        ], 
    

                        [
                            'name'=>'مستحقات المؤسسة العامة للتأمينات الاجتماعية',
                            'code'=>2108,
            
                            'sub_account1_id'=>'',
                        ], 
    

                        [
                            'name'=>'مجمع الاستهلاك',
                            'code'=>2109,
            
                            'sub_account1_id'=>'',
                            4=>[


       
                                [ 'name'=>'مجمع استهلاك المباني',
                                'code'=>210901,
                    
                                'sub_account3_id'=>''] ,
                    
                                [ 'name'=>'مجمع استهلاك المعدات',
                                'code'=>210902,
                    
                                'sub_account3_id'=>'',] ,
                    
                                [ 'name'=>'مجمع استهلاك أجهزة مكتبية وطابعات',
                                'code'=>210903,
                    
                                'sub_account3_id'=>'',] ,
                    
             
                    
                    
                            ],
       
                        ], 

                        [
                            'name'=>'مخصص مكافأة نهاية الخدمة',
                            'code'=>21010,
            
                            'sub_account1_id'=>'',
                        ], 
    
               
    
    


                    ],


    [
    [
        'name'=>'قروض طويلة الأجل',
        'code'=>2201,

        'sub_account1_id'=>'',  
    ]
    ],
[



    [
        'name'=>' رأس المال الاضافي المدفوع ',
        'code'=>3101,

        'sub_account1_id'=>'',
    ], 


    
    [
        'name'=>' رأس المال  المسجل ',
        'code'=>3102,

        'sub_account1_id'=>'',
    ], 


],
                

[



    [
        'name'=>'الارصده الافتتاحيه',
        'code'=>3201,

        'sub_account1_id'=>'',
    ], 


    
 

],

[



    [
        'name'=>'احتياطي ترجمة عملات أجنبية ',
        'code'=>3301,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'احتياطي نظامي',
        'code'=>3302,

        'sub_account1_id'=>'',
    ], 


    
 

],

[



    [
        'name'=>'الأرباح والخسائر العاملة',
        'code'=>3401,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'الأرباح المبقاة (أو الخسائر)',
        'code'=>3402,

        'sub_account1_id'=>'',
    ], 


    
 

],



[



    [
        'name'=>'إيرادات المبيعات/ الخدمات',
        'code'=>4101,

        'sub_account1_id'=>'',
    ], 


],

[



    [
        'name'=>'إيرادات أخرى',
        'code'=>4201,

        'sub_account1_id'=>'',
    ], 


],


[



    [
        'name'=>'تكلفة البضاعة المباعة',
        'code'=>5101,

        'sub_account1_id'=>'',
    ], 


    
    [
        'name'=>'رواتب وأجور',
        'code'=>5102,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'عمولات البيع',
        'code'=>5103,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'شحن وتخليص جمركي',
        'code'=>5104,

        'sub_account1_id'=>'',
    ], 




],


[



    [
        'name'=>'الرواتب والرسوم الإدارية ',
        'code'=>5201,

        'sub_account1_id'=>'',
    ], 


    
    [
        'name'=>'تأمين طبي ',
        'code'=>5202,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'مصاريف تسويقية ودعائية',
        'code'=>5203,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'مصاريف الإيجار',
        'code'=>5204,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'عمولات وحوافز',
        'code'=>5205,

        'sub_account1_id'=>'',
    ], 


    [
        'name'=>'تذاكر سفر',
        'code'=>5206,

        'sub_account1_id'=>'',
    ],
    
    [
        'name'=>'التأمينات الاجتماعية',
        'code'=>5207,

        'sub_account1_id'=>'',
    ],

      [
        'name'=>'الرسوم الحكومية',
        'code'=>5208,

        'sub_account1_id'=>'',
    ],

    [
        'name'=>'رسوم واشتراكات',
        'code'=>5209,

        'sub_account1_id'=>'',
    ],

    [
        'name'=>'مصاريف خدمات المكتب',
        'code'=>52010,

        'sub_account1_id'=>'',
    ],


    [
        'name'=>'مصاريف مكتبية ومطبوعات',
        'code'=>52011,

        'sub_account1_id'=>'',
    ],


    [
        'name'=>'مصاريف ضيافة',
        'code'=>52012,

        'sub_account1_id'=>'',
    ],


    [
        'name'=>'عمولات بنكية',
        'code'=>52013,

        'sub_account1_id'=>'',
    ],

    [
        'name'=>'مصاريف أخرى',
        'code'=>52014,

        'sub_account1_id'=>'',
    ],


    [
        'name'=>'مصاريف الإهلاك',
        'code'=>52015,

        'sub_account1_id'=>'',
        4=>[


       
            [ 'name'=>'مصروف إهلاك المباني',
            'code'=>521501,

            'sub_account3_id'=>''] ,

            [ 'name'=>'مصروف إهلاك المعدات',
            'code'=>521502,

            'sub_account3_id'=>'',] ,

            [ 'name'=>'مصروف إهلاك أجهزة مكتبية وطابعات',
            'code'=>521503,

            'sub_account3_id'=>'',] ,




        ],

    ],


    [
        'name'=>'مصروف نقل ومواصلات',
        'code'=>52019,

        'sub_account1_id'=>'',
    ],




],


[

[
    'name'=>'الزكاة',
    'code'=>5301,

    'sub_account1_id'=>'',
],

[
    'name'=>'الضرائب',
    'code'=>5302,

    'sub_account1_id'=>'',
],

[
    'name'=>'ترجمة عملات أجنبية',
    'code'=>5303,

    'sub_account1_id'=>'',
],

[
    'name'=>'فوائد',
    'code'=>5304,

    'sub_account1_id'=>'',
],



],



                   ];
            
   
   $cp = 0;
   
   
                   foreach($b as $t){
          $su =      subaccount1::create($t);

          foreach($s[$cp] as $c){

            $c['sub_account1_id']  = $su->id;
       

        $d =   sub_account3::create(      [
            'name'=>$c['name'],
            'code'=>$c['code'],
    
            'sub_account1_id'=>$c['sub_account1_id'],
        ]
    );
            
    if(!empty($c['4'])){

        foreach($c['4'] as $tt){
            $tt['sub_account3_id'] =$d->id;
            sub_account4::create($tt);
        }

    }

          }
++$cp;
            }
                        

    }


   
}
