<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\delivery_bond;
use App\customer;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
class deliver_bondController extends Controller
{

  public function __construct()
  {
      $this->middleware('auth');
  }

  
    public function index(){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
 
return view('delivery_bond.index');
        }
    }

    public function create(){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
 
return view('delivery_bond.create');
        }
    }


           // Loading data into print page 

    public function get_dp($id) {

      if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){

        $data =  auth()->user()->orderpackage->delivery_bond()->where('id',$id)->with('product')->first();
        $data2 =  auth()->user()->orderpackage->delivery_bond()->where('id',$id)->first();
        $customer = auth()->user()->orderpackage->customer->find($data->customer_id);
        $term = auth()->user()->orderpackage->term->find($data->fq_id);
       
        $slug =  [
          'customer'=>$customer ?? null,
          'delivery'=>$data2 ?? null,
        ];

        $customer = json_encode($customer);
        $data = json_encode($data);
        $term = json_encode($term);

      

        $arrData = json_encode($slug, JSON_UNESCAPED_UNICODE);




 
        return  view('print.deliverybonds')->with(['data'=> $data ,'q'=>$arrData ,'customer' => $customer, 'term' => $term, 'title' => 'سند تسليم بضاعه']);
                }





    }

    public function insert(request $request){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
 
        $this->validate($request,[
            'financial_year'=>['required','string','max:255'],

            'date'=>['required','date'],
             
     
          'send_date'=>['required','date'],
             
      'receive_date'=>['required','date'],
             
     
           'sender'=>['required','string','max:255'],
     'supplier_id'=>['required','numeric'],
 
        ]);

    $delivery_bond=     delivery_bond::create([
            'financial_year'=>$request->financial_year,

            'date'=>$request->date,
             
     
          'send_date'=>$request->send_date,
             
      'receive_date'=>$request->receive_date,
      'orderpackage_id'=>auth()->user()->orderpackage->id,
    //  'reciver_name'=>$request->reciver_name,
    //  'fq_id'=>$request->fq_id,
     
           'sender'=>$request->sender,
     'customer_id'=>$request->supplier_id,
        ]);


        $product = json_decode($request->product, true);
        foreach($product as $v){
        
            $delivery_bond->product()->attach($v['id'], [
               
                'quantity' => $v['quantity'],
            ]);
        }



    }
}


public function deliveryjson(){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
  $pr = auth()->user()->orderpackage->delivery_bond()->orderBy('created_at', 'DESC')->with('customer')->paginate(10);
  return response()->json(['data'=>$pr]);
  
  
    }
  }
  
  
  public function delete($ids){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
      auth()->user()->orderpackage->delivery_bond()->whereIn('id',explode(",",$ids))->delete();
    }
  }

  public function updatesdelivery_bond(request $request,delivery_bond $delivery_bond ){
    if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
$delivery_bond->update([
'customer_id'=>$request->customer_id,
'financial_year'=>$request->financial_year
]);
          return response()->json('done',200);
        }
              }

}
