<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\purchase_order;
use App\payment_purchase;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Validator;
use App\entry_manual;
use App\entry_manual_account;
use DB;
use App\Exceptions\CustomException;
use App\product;
class purchase_orderController extends Controller
{
  public function __construct()
  {
      $this->middleware('auth');
  }
  
  public function index(){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','read_أوامر الشراء')->count() > 0
    
  
    
    ){
return view('purchases.index');


    }

  }

  public function create(){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','add_أوامر الشراء')->count() > 0
    
  
    
    ){
        return view('purchases.create');
        
        
            }
  }

  public function insert(request $request){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','add_أوامر الشراء')->count() > 0
    
  
    
    ){
    $this->validate($request,[

      'discount'=>['numeric'],
       'tax'=>['required','numeric'],
   'total_amount'=>['required','numeric'],
   'branch_id'=>['required','numeric'],
   'overall'=>['required','numeric'],
   'per_discount'=>['numeric'], 
   'supplier_id'=>['required','numeric'],
   
           ]);
           
           try{
 
            DB::transaction(function () use ($request) {

           $codepurchase_order = auth()->user()->orderpackage->purchase_order()->count() +1;
$purchase_order = purchase_order::create([
    'supplier_id'=>$request->supplier_id,
    'fq'=>$request->fq,
    'code'=>$codepurchase_order,
    'tax'=>$request->tax,
    'date'=>\Carbon\Carbon::now()->format('m/d/Y'),
    'total_amount'=>$request->total_amount,
    'discount'=>$request->discount,
    'branch_id'=>$request->branch_id,
    'orderpackage_id'=>auth()->user()->orderpackage->id,
    'overall'=>$request->overall,
    'pricing_supplier_id'=>$request->pricing_supplier_id,
    'tax_number'=>$request->tax_number,
    'pre_discount'=>$request->pre_discount
]);



$product = json_decode($request->product, true);
$payment = json_decode($request->payment, true);



$code = auth()->user()->orderpackage->entry_manual->count() + 1;
        $entry_manual = entry_manual::create([
      'orderpackage_id'=>auth()->user()->orderpackage->id,
     'date'=>\Carbon\Carbon::now()->format('Y-m-d'),
           'creditor_id'=> null, 
            'value'=>$purchase_order->overall,
        'dis'=>'فاتورة شراء '.''.$codepurchase_order,
        'line'=>1,
'type'=>20,
      'code'=>$code,
      'hide'=>1
        ]);




if( $entry_manual->sub_account3()->count() > 0){
    $entry_manual->sub_account3()->decrement('initial_balance',$purchase_order->overall);
    
    $entry_manual->sub_account3->subaccount1()->decrement('initial_balance',$purchase_order->overall);
    $entry_manual->sub_account3->subaccount1->accountbank->decrement('initial_balance',$purchase_order->overall);
}

$rules = [
  "quantity"  => "required|numeric",
 'id'=> 'required','numeric','exists:products,id',
 'selling'  => "required|numeric",
];

foreach($product as $v){
  $array = [
    "quantity"  => $v['pivot']['quantity'] ?? null ,
   'id'=> $v['id'] ?? null,
   'selling' => $v['pivot']['selling'],
   
];
$validator = Validator::make(
  $array,$rules
  
    );

if ($validator->passes() ) {
    $purchase_order->product()->attach($v['id'], [
        'quantity' => $v['pivot']['quantity'],
        'selling' => $v['pivot']['selling'],
    ]);
    $total = $v['pivot']['selling'] * $v['pivot']['quantity'] ?? 0;
if($v['inventory'] == 1){


  $da =  auth()->user()->orderpackage->accountbank()->where('code',1)->with(['subaccount1'=>
        function($d){
            $d->where('code',11)->with(['sub_account3'=> function($r) {
         return   
   
         $r->where('code',1106);
           }]);
        }]);
        $da = $da->first();
        $d = $da['subaccount1'][0]['sub_account3'][0]['id'];
   
      
  $e =  entry_manual_account::create([
    'debtor_account3_id'=>null,
     'debtor_sub_account4_id'=>null,
     'debtor_account3_id'=>$d,
  'entry_manual_id'=>$entry_manual->id,
  'value'=>$total,
  'date'=>$entry_manual->date,
  ]);

 
   
  if($e->sub_account4()->count() > 0){
    $e->sub_account4()->increment('initial_balance',$total);
    
      $e->sub_account4->sub_account3()->increment('initial_balance',$total);
      $e->sub_account4->sub_account3->subaccount1()->increment('initial_balance',$total);
      $e->sub_account4->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
  }
  
  if($e->sub_account3()->count() > 0){
    $e->sub_account3()->increment('initial_balance',$total);
         
    $e->sub_account3->subaccount1()->increment('initial_balance',$total);
    $e->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
  }

}
   
    


  
}else{
     
  $errors  = $validator->errors()->toArray();
  $data = json_encode($errors);

          throw new CustomException ($data);

}


}

$da =  auth()->user()->orderpackage->accountbank()->where('code',2)->with(['subaccount1'=>
function($d){
    $d->where('code',21)->with(['sub_account3'=> function($r) {
 return   

 $r->where('code',2101);
   }]);
}]);
$da = $da->first();
$d = $da['subaccount1'][0]['sub_account3'][0]['id'];


$e =  entry_manual_account::create([
  'debtor_account3_id'=>null,
   'debtor_sub_account4_id'=>null,
   'creditor_sub_account3_id'=>$d,
'entry_manual_id'=>$entry_manual->id,
'value'=>$purchase_order->overall,
'date'=>$entry_manual->date,
]);

$e->creditor_sub_account3()->decrement('initial_balance',$purchase_order->overall);
$e->creditor_sub_account3->subaccount1()->decrement('initial_balance',$purchase_order->overall);
$e->creditor_sub_account3->subaccount1->accountbank->decrement('initial_balance',$purchase_order->overall);

foreach($product as $v){


    $total = $v['pivot']['selling'] * $v['pivot']['quantity'] ?? 0;
if($v['inventory'] !== 1){
  $e =  entry_manual_account::create([
     'debtor_sub_account4_id'=>$v['p_account4_id'],
     'debtor_account3_id'=>$v['p_account3_id'],
  'entry_manual_id'=>$entry_manual->id,
  'value'=>$total,
  'date'=>$entry_manual->date,
  ]);


}
if($e->sub_account4()->count() > 0){
  $e->sub_account4()->increment('initial_balance',$total);
  
    $e->sub_account4->sub_account3()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}

if($e->sub_account3()->count() > 0){
  $e->sub_account3()->increment('initial_balance',$total);
       
  $e->sub_account3->subaccount1()->increment('initial_balance',$total);
  $e->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}
  
}



foreach($product as $v){


    $total = $v['pivot']['selling'] * $v['pivot']['quantity'] ?? 0;

    if($purchase_order->tax > 0){
      $da =  auth()->user()->orderpackage->accountbank()->where('code',2)->with(['subaccount1'=>
    function($d){
        $d->where('code',21)->with(['sub_account3'=> function($r) {
     return   
    
     $r->where('code',2105);
       }]);
    }]);
    $da = $da->first();
    $d = $da['subaccount1'][0]['sub_account3'][0]['id'];
   
    $tax =  auth()->user()->orderpackage->branch->where('id',$request->branch_id)->first();

      $e =  entry_manual_account::create([
        'debtor_account3_id'=>null,
         'debtor_sub_account4_id'=>null,
         'debtor_account3_id'=>$d,
      'entry_manual_id'=>$entry_manual->id,
      'value'=>  $v['pivot']['quantity'] * $v['pivot']['selling']  * $tax->tax / 100,
      
   
      
      'date'=>$entry_manual->date,
      ]);
    
    }



if($e->sub_account4()->count() > 0){
  $e->sub_account4()->increment('initial_balance',$total);
  
    $e->sub_account4->sub_account3()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}

if($e->sub_account3()->count() > 0){
  $e->sub_account3()->increment('initial_balance',$total);
       
  $e->sub_account3->subaccount1()->increment('initial_balance',$total);
  $e->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}
  
}





$a = [];
if(!empty($payment)){
foreach($payment as $p){
  $rules = [
          
       
    "percentage"  => "required|numeric",

   
    'name'=> "required|string|max:255",
   'note'=> "string|max:255",
   
   'amount'=> "required|numeric",
   
];
$validator = Validator::make($p, $rules);

if ($validator->passes()) {
  $a[] = [
      'purchase_order_id'=>$purchase_order->id,
      'percentage'=>$p['percentage'],
   'name'=>$p['name'],
  'note'=>$p['note'] ?? null ,
  
  'amount'=>$p['amount'],
  
  ];
  
}
}
payment_purchase::insert($a);





}
 });
 


}
catch (Exception $e) {
    return $e;
}




    }
  }

  
  public function purchase_orderjson(){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){

return response()->json(['data'=>auth()->user()->orderpackage->purchase_order()->with(['supplier','pricing_supplier'])->orderBy('created_at', 'DESC')->paginate(10)]);

    }
}

public function updatepurchase_order(request $request,purchase_order $purchase_order ){
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
  && 
  auth()->user()->role->permession->where('name','add_أوامر الشراء')->count() > 0
  

  
  ){
$purchase_order->update([
'supplier_id'=>$request->supplier_id,
'pricing_supplier_id'=>$request->pricing_supplier_id
]);
        return response()->json('done',200);
      }
            }
            public function bill1($id){
              if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
        
              && 
              auth()->user()->role->permession->where('name','read_الفواتير')->count() > 0
              
            
              
              ){
                 if(auth()->user()->orderpackage->purchase_order()->where('id',$id)->first()){
      
      $data = auth()->user()->orderpackage->purchase_order()->with([
        'product','supplier','payment_pricing','branch','pricing_supplier'
      ])->where('id',$id)->first();
      
      $slug = [
          'name'=>$data->branch->name ?? null,
          'tax_number'=>$data->branch->tax_number  ?? null,
          'date'=>$data->created_at->format('d/m/Y') ?? null,
      'tax'=>$data->tax  ?? null,
      'total_amount'=>$data->overall ?? null,
      
      
      
      ];
      
      $arrData = json_encode($slug, JSON_UNESCAPED_UNICODE);
      
      $q =  QrCode::size(190)->encoding('UTF-8')
      ->backgroundColor(255, 255, 204)
      
      ->generate($arrData);
      
      
      return view('bill.bill3')->with(['data'=>$data,'slug'=>$q]);
                 }
              }
                 
             }

            public function delete($ids){
              if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
              && 
              auth()->user()->role->permession->where('name','delete_أوامر الشراء')->count() > 0
              
            
              
              ){
                auth()->user()->orderpackage->purchase_order()->whereIn('id',explode(",",$ids))->delete();
              }
            }
      

}
