<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\stock_movement;

class stock_movementController extends Controller
{
  public function __construct()
  {
      $this->middleware('auth');
  }
  
   public function index(){
       return view('stock_movement.index');
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','read_نقل المخزون')->count() > 0
    
  
    
    ){
return view('stock_movement.index');
    }
   }

   public function create(){
       return view('stock_movement.create');

    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','add_نقل المخزون')->count() > 0
    
  
    
    ){
return view('stock_movement.create');
    }
   }

   public function insert(request $request){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
  //  && 
   // auth()->user()->role->permession->where('name','add_نقل المخزون')->count() > 0
    
  
    
    ){
        $this->validate($request,[

            'financial_year'=>['required','string','max:255'],

            
  

             'date'=>['required','date'],
             'from'=>['required','numeric','digits_between:1,4'],
             'purpose'=>['required','numeric','digits_between:1,4'],
             'expense_account'=>['required','string','max:255'],
              'cost_center'=>['required','string','max:255'],
             'to'=>['required','numeric','digits_between:1,4'],
     
                 ]);

  $stock_movement = new stock_movement;
  $stock_movement->financial_year= $request->financial_year;
  $stock_movement->date=$request->date;
  $stock_movement->from=$request->from;
  $stock_movement->to=$request->to;
  $stock_movement->expense_account  = $request->expense_account;
  $stock_movement->cost_center  = $request->cost_center;

  if($request->from == 1){
    $stock_movement->customer_from_id=$request->from_id;
  }
  if($request->from == 2){
    $stock_movement->supplier_from_id=$request->from_id;

  }
 
  if($request->from == 4){
    $stock_movement->inventory_from_id=$request->from_id;
  }

  if($request->to == 2){
    $stock_movement->supplier_to_id=$request->to_id;
  }
 

  if($request->to == 1){
    $stock_movement->customer_to_id=$request->to_id;
  }

  if($request->to == 4){
    $stock_movement->inventory_to_id=$request->to_id;
  }

  $stock_movement->person_to = $request->person_to;
  $stock_movement->person = $request->person;
  $stock_movement->orderpackage_id = auth()->user()->orderpackage->id;
  $stock_movement->purpose = $request->purpose;
  $stock_movement->save();

  $product = json_decode($request->product, true);

  
  foreach($product as $v){
  
    $stock_movement->product()->attach($v['id'], [
          'quantity' => $v['quantity'],
          'selling' => $v['price'],
      ]);
  
  
  }

    }
   }


   public function jsonstocck(){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){

      $pr = auth()->user()->orderpackage->stock_movement()->orderBy('created_at', 'DESC')->with(['supplier_from',
      'customer_from','customer_to','inventory_from','inventory_to','supplier_to'])->paginate(10);
      return response()->json(['data'=>$pr]);
      
      

    }
   }


   public function delete($ids){
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
    && 
    auth()->user()->role->permession->where('name','delete_نقل المخزون')->count() > 0
    
  
    
    ){
      auth()->user()->orderpackage->stock_movement()->whereIn('id',explode(",",$ids))->delete();
    }
  }
}
