<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','phone','orderpackage_id','role_id'    ,    'last_name',
        'cashier',
        'status',
        'city',
        'in_branch',
        'rep_code',
        'is_banned'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function orderpackage(){
        return $this->belongsto(orderpackage::class,'orderpackage_id');
    }

    public function role(){
        return $this->belongsto(role::class,'role_id');
    }

    public function cart(){
        return $this->HasMany(cart::class,'user_id');
    }

    
    public function inbranch(){
        return $this->belongsto(branch::class,'in_branch');
    }

    public function message(){
        return $this->hasMany(message::class);
    }

    
}
