<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class purchase_order extends Model
{
    protected $fillable = [
        'orderpackage_id',
            'price',
           'discount',
            'tax',
        'total_amount',
        'supplier_id',
        'code',
        'date',
        'taxnum',
        'showprice_id',
        'tax_number',
        'fq',
        'pricing_supplier_id',
        'pre_discount',
        'overall',
    'branch_id'  

];


    

    
    public function product(){
        return $this->belongstomany(product::class,'purchase_order_product')->withPivot('purchase_order_id','product_id','quantity','selling');
    }
    

    public function pricing_supplier(){
        return $this->belongsto(pricing_supplier::class,'pricing_supplier_id');
    }



    public function supplier(){
        return $this->belongsto(supplier::class,'supplier_id');
    }
    

    public function payment_pricing(){
        return $this->HasMany(payment_purchase::class,'purchase_order_id');
    }

    public function branch(){
        return $this->belongsto(branch::class,'branch_id');
    }
    

 
}
