<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class stock_movement extends Model
{
    protected $fillable = [
      'financial_year',

     'date',
'from',
'supplier_from_id',
'supplier_to_id',
'customer_from_id',
'customer_to_id',
'inventory_from_id',
'inventory_to_id',
'orderpackage_id',
'person_to',
'to',
'purpose',
'expense_account',
'cost_center',
'person'

    ];



    public function supplier_from(){
        return $this->belongsto(supplier::class,'supplier_from_id');
    }

    public function supplier_to(){
        return $this->belongsto(supplier::class,'supplier_to_id');
    }

    public function customer_from(){
        return $this->belongsto(customer::class,'customer_from_id');
    }

    public function customer_to(){
        return $this->belongsto(customer::class,'customer_to_id');
    }

    
    public function inventory_from(){
        return $this->belongsto(inventory::class,'inventory_from_id');
    }

    public function inventory_to(){
        return $this->belongsto(inventory::class,'inventory_to_id');
    }

    public function product(){
        return $this->belongstomany(product::class,'stock_movements_product')->withPivot('stock_movement_id','product_id','quantity','selling');
    }

    
}
