/**
 * <p>Encapsulates the parameters for one error-correction block in one symbol version.
 * This includes the number of data codewords, and the number of times a block with these
 * parameters is used consecutively in the QR code version's format.</p>
 */
export default class ECB {
    constructor(count /*int*/, dataCodewords /*int*/) {
        this.count = count;
        this.dataCodewords = dataCodewords;
    }
    getCount() {
        return this.count;
    }
    getDataCodewords() {
        return this.dataCodewords;
    }
}
//# sourceMappingURL=ECB.js.map