"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prevent = prevent;
exports.default = void 0;

var _VInput = _interopRequireDefault(require("../../components/VInput"));

var _rippleable = _interopRequireDefault(require("../rippleable"));

var _comparable = _interopRequireDefault(require("../comparable"));

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Components
// Mixins
// Utilities
function prevent(e) {
  e.preventDefault();
}
/* @vue/component */


var _default = (0, _mixins.default)(_VInput.default, _rippleable.default, _comparable.default).extend({
  name: 'selectable',
  model: {
    prop: 'inputValue',
    event: 'change'
  },
  props: {
    id: String,
    inputValue: null,
    falseValue: null,
    trueValue: null,
    multiple: {
      type: Boolean,
      default: null
    },
    label: String
  },
  data: function data() {
    return {
      hasColor: this.inputValue,
      lazyValue: this.inputValue
    };
  },
  computed: {
    computedColor: function computedColor() {
      if (!this.isActive) return undefined;
      if (this.color) return this.color;
      if (this.isDark && !this.appIsDark) return 'white';
      return 'primary';
    },
    isMultiple: function isMultiple() {
      return this.multiple === true || this.multiple === null && Array.isArray(this.internalValue);
    },
    isActive: function isActive() {
      var _this = this;

      var value = this.value;
      var input = this.internalValue;

      if (this.isMultiple) {
        if (!Array.isArray(input)) return false;
        return input.some(function (item) {
          return _this.valueComparator(item, value);
        });
      }

      if (this.trueValue === undefined || this.falseValue === undefined) {
        return value ? this.valueComparator(value, input) : Boolean(input);
      }

      return this.valueComparator(input, this.trueValue);
    },
    isDirty: function isDirty() {
      return this.isActive;
    },
    rippleState: function rippleState() {
      return !this.isDisabled && !this.validationState ? undefined : this.validationState;
    }
  },
  watch: {
    inputValue: function inputValue(val) {
      this.lazyValue = val;
      this.hasColor = val;
    }
  },
  methods: {
    genLabel: function genLabel() {
      var label = _VInput.default.options.methods.genLabel.call(this);

      if (!label) return label;
      label.data.on = {
        // Label shouldn't cause the input to focus
        click: prevent
      };
      return label;
    },
    genInput: function genInput(type, attrs) {
      return this.$createElement('input', {
        attrs: Object.assign({
          'aria-checked': this.isActive.toString(),
          disabled: this.isDisabled,
          id: this.computedId,
          role: type,
          type: type
        }, attrs),
        domProps: {
          value: this.value,
          checked: this.isActive
        },
        on: {
          blur: this.onBlur,
          change: this.onChange,
          focus: this.onFocus,
          keydown: this.onKeydown,
          click: prevent
        },
        ref: 'input'
      });
    },
    onBlur: function onBlur() {
      this.isFocused = false;
    },
    onClick: function onClick(e) {
      this.onChange();
      this.$emit('click', e);
    },
    onChange: function onChange() {
      var _this2 = this;

      if (!this.isInteractive) return;
      var value = this.value;
      var input = this.internalValue;

      if (this.isMultiple) {
        if (!Array.isArray(input)) {
          input = [];
        }

        var length = input.length;
        input = input.filter(function (item) {
          return !_this2.valueComparator(item, value);
        });

        if (input.length === length) {
          input.push(value);
        }
      } else if (this.trueValue !== undefined && this.falseValue !== undefined) {
        input = this.valueComparator(input, this.trueValue) ? this.falseValue : this.trueValue;
      } else if (value) {
        input = this.valueComparator(input, value) ? null : value;
      } else {
        input = !input;
      }

      this.validate(true, input);
      this.internalValue = input;
      this.hasColor = input;
    },
    onFocus: function onFocus() {
      this.isFocused = true;
    },

    /** @abstract */
    onKeydown: function onKeydown(e) {}
  }
});

exports.default = _default;
//# sourceMappingURL=index.js.map