"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = goTo;
exports.Goto = void 0;

var _service = require("../service");

var easingPatterns = _interopRequireWildcard(require("./easing-patterns"));

var _util = require("./util");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function goTo(_target) {
  var _settings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var settings = _objectSpread({
    container: document.scrollingElement || document.body || document.documentElement,
    duration: 500,
    offset: 0,
    easing: 'easeInOutCubic',
    appOffset: true
  }, _settings);

  var container = (0, _util.getContainer)(settings.container);
  /* istanbul ignore else */

  if (settings.appOffset && goTo.framework.application) {
    var isDrawer = container.classList.contains('v-navigation-drawer');
    var isClipped = container.classList.contains('v-navigation-drawer--clipped');
    var _goTo$framework$appli = goTo.framework.application,
        bar = _goTo$framework$appli.bar,
        top = _goTo$framework$appli.top;
    settings.offset += bar;
    /* istanbul ignore else */

    if (!isDrawer || isClipped) settings.offset += top;
  }

  var startTime = performance.now();
  var targetLocation;

  if (typeof _target === 'number') {
    targetLocation = (0, _util.getOffset)(_target) - settings.offset;
  } else {
    targetLocation = (0, _util.getOffset)(_target) - (0, _util.getOffset)(container) - settings.offset;
  }

  var startLocation = container.scrollTop;
  if (targetLocation === startLocation) return Promise.resolve(targetLocation);
  var ease = typeof settings.easing === 'function' ? settings.easing : easingPatterns[settings.easing];
  /* istanbul ignore else */

  if (!ease) throw new TypeError("Easing function \"".concat(settings.easing, "\" not found.")); // Cannot be tested properly in jsdom

  /* istanbul ignore next */

  return new Promise(function (resolve) {
    return requestAnimationFrame(function step(currentTime) {
      var timeElapsed = currentTime - startTime;
      var progress = Math.abs(settings.duration ? Math.min(timeElapsed / settings.duration, 1) : 1);
      container.scrollTop = Math.floor(startLocation + (targetLocation - startLocation) * ease(progress));
      var clientHeight = container === document.body ? document.documentElement.clientHeight : container.clientHeight;
      var reachBottom = clientHeight + container.scrollTop >= container.scrollHeight;

      if (progress === 1 || // Need to go lower but reach bottom
      targetLocation > container.scrollTop && reachBottom) {
        return resolve(targetLocation);
      }

      requestAnimationFrame(step);
    });
  });
}

goTo.framework = {};

goTo.init = function () {};

var Goto = /*#__PURE__*/function (_Service) {
  _inherits(Goto, _Service);

  var _super = _createSuper(Goto);

  function Goto() {
    var _this;

    _classCallCheck(this, Goto);

    _this = _super.call(this);
    return _possibleConstructorReturn(_this, goTo);
  }

  return Goto;
}(_service.Service);

exports.Goto = Goto;
Goto.property = 'goTo';
//# sourceMappingURL=index.js.map