import { install } from './install'; // Services

import * as services from './services';
export default class Vuetify {
  constructor(userPreset = {}) {
    this.framework = {
      isHydrating: false
    };
    this.installed = [];
    this.preset = {};
    this.userPreset = {};
    this.userPreset = userPreset;
    this.use(services.Presets);
    this.use(services.Application);
    this.use(services.Breakpoint);
    this.use(services.Goto);
    this.use(services.Icons);
    this.use(services.Lang);
    this.use(services.Theme);
  } // Called on the new vuetify instance
  // bootstrap in install beforeCreate
  // Exposes ssrContext if available


  init(root, ssrContext) {
    this.installed.forEach(property => {
      const service = this.framework[property];
      service.framework = this.framework;
      service.init(root, ssrContext);
    }); // rtl is not installed and
    // will never be called by
    // the init process

    this.framework.rtl = Boolean(this.preset.rtl);
  } // Instantiate a VuetifyService


  use(Service) {
    const property = Service.property;
    if (this.installed.includes(property)) return; // TODO maybe a specific type for arg 2?

    this.framework[property] = new Service(this.preset, this);
    this.installed.push(property);
  }

}
Vuetify.install = install;
Vuetify.installed = false;
Vuetify.version = "2.6.0";
Vuetify.config = {
  silent: false
};
//# sourceMappingURL=framework.js.map