<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
})->name('welcome');
Route::get('/hello', function () {
    return view('hello');
})->name('hello');

Auth::routes();




//                     Dashboard         

Route::get('/dashboard/index',"dashboardController@index")->name('index');



Route::get('/get_users',"dashboardController@get_users")->name('get_users');

Route::post('/Renew_sub',"dashboardController@Renew_sub")->name('Renew_sub');

Route::post('/sendmsg',"dashboardController@sendmsg")->name('sendmsg');


Route::post('/ban_user',"dashboardController@ban_user")->name('ban_user');

Route::post('/unban_user',"dashboardController@unban_user")->name('unban_user');


//                     Dashboard    --->  Representative

Route::get('/dashboard/representative',"dashboardController@representativeindex")->name('representativeindex');

Route::post('/dashboard/rep_insert',"RepresentativeController@rep_insert")->name('rep_insert');

Route::get('/get_rep',"RepresentativeController@get_rep")->name('get_rep');

Route::post('/delete_rep',"RepresentativeController@delete_rep")->name('delete_rep');





Route::get('/hceout/{package}', 'HomeController@hceout')->name('hceout');

Route::get('/payz', 'HomeController@pay')->name('payz');

Route::get('/home', 'HomeController@index')->name('home');


Route::get('/features', 'uiController@features')->name('features');

Route::get('/representative', 'uiController@berep')->name('berep');

Route::get('/sectors', 'uiController@sectors')->name('sectors');


Route::get('/prices', 'uiController@price')->name('pricing');



//customer
Route::get('/addcpage', 'customerController@addcpage')->name('addcpage');
Route::post('/customer', 'customerController@customer')->name('customer');

Route::get('/customerjson', 'customerController@customerjson')->name('customerjson');

Route::get('/customerindex', 'customerController@index')->name('customerindex');

Route::get('/customerdebetor', 'customerController@customerdebetor')->name('customerdebetor');




  Route::post('/deletecustomer/{ids}', 'customerController@delete')->name('deletecustomer');


  Route::post('/updatecustomer/{customer}', 'customerController@updatecustomer')->name('updatecustomer');



//product
Route::post('/addproduct', 'productController@addproduct')->name('addproduct');

Route::get('/product', 'productController@product')->name('producct');

Route::get('/productjson', 'productController@productjson')->name('productjson');


Route::get('/productselect', 'productController@productselect')->name('productselect');


Route::get('/productedit/{product}', 'productController@edit')->name('productedit');


Route::post('/updateproduct/{product}', 'productController@updateproduct')->name('updateproduct');




Route::post('/editproduct/{product}', 'productController@editproduct')->name('editproduct');

Route::post('/deleteproduct/{ids}', 'productController@delete')->name('deleteproduct');
Route::get('/producttable', 'productController@producttable')->name('producttable');

//category 
Route::post('/getselectcategory', 'categoryController@getselectcategory')->name('getselectcategory');

Route::get('/create-category', 'categoryController@index')->name('create-category');

Route::get('/tablejson-category', 'categoryController@tablejson')->name('tablejson-category');


Route::get('/table-category', 'categoryController@table')->name('table-category');

Route::get('/categoryget/{id}', 'categoryController@categoryget')->name('categoryget');

Route::post('/updatecategory/{category}', 'categoryController@updatecategory')->name('updatecategory');



Route::post('/categorydelete/{id}', 'categoryController@delete')->name('categorydelete');

Route::post('/post-category', 'categoryController@create')->name('post-category');






//inventory
Route::get('/inventoryedit/{inventory}', 'inventoryController@edit')->name('inventoryedit');


Route::get('/inventoryselectbox', 'inventoryController@inventoryselectbox')->name('inventoryselectbox');

Route::get('/createinventory', 'inventoryController@create')->name('createinventory');

Route::post('/inventoryinserter', 'inventoryController@inventoryinserter')->name('inventoryinserter');

Route::post('/inventoryupdate/{inventory}', 'inventoryController@update')->name('inventoryupdatez');



Route::get('/inventoryhome', 'inventoryController@home')->name('inventoryhome');

Route::post('/getselectinventory', 'inventoryController@getselectinventory')->name('getselectinventory');

Route::get('/inventoryhomedata', 'inventoryController@inventoryhomedata')->name('inventoryhomedata');

Route::post('/deleteinventory/{inventory}', 'inventoryController@delete')->name('deleteinventory');

//supplier
Route::post('/getselectboxsupp', 'supplierController@getselectboxsupp')->name('getselectboxsupp');

Route::get('/createsupplier', 'supplierController@createpage')->name('createpage');

Route::get('/supplierselex', 'supplierController@supplierselex')->name('supplierselex');
Route::get('/suppilercount', 'supplierController@suppilercount')->name('suppilercount');



Route::post('/createsupp', 'supplierController@createsupp')->name('createsupp');

Route::get('/suppliertable', 'supplierController@suppliertable')->name('suppliertable');


Route::get('/supplierjson', 'supplierController@supplierjson')->name('supplierjson');

Route::post('/deletesupp/{ids}', 'supplierController@delete')->name('deletesup');

Route::post('/updatesupp/{supplier}', 'supplierController@updatesupp')->name('updatesupp');



  


Route::post('/getselectcustomer', 'salesController@getselectcustomer')->name('getselectcustomer');
Route::post('/getselectproduct', 'salesController@getselectproduct')->name('getselectproduct');
Route::get('/createoffer', 'salesController@createoffer')->name('createoffer');
Route::get('/getofferpaid', 'salesController@getofferpaid')->name('getofferpaid');

Route::post('/getselectproductbarcode', 'salesController@getselectproductbarcode')->name('getselectproductbarcode');

Route::post('/getselectproductname', 'salesController@getselectproductname')->name('getselectproductname');


Route::post('/getselectproductbarcodepurchase', 'salesController@getselectproductbarcodepurchase')->name('getselectproductbarcodepurchase');

Route::post('/getselectproductnamepurchase', 'salesController@getselectproductnamepurchase')->name('getselectproductnamepurchase');




Route::post('/insertoffer', 'salesController@insertoffer')->name('insertoffer');

Route::get('/offerpaidlist', 'salesController@offerpaidpage')->name('offerpaidlist');
Route::get('/offerpaidjson', 'salesController@offerpaidjson')->name('offerpaidjson');

Route::get('/offertable', 'salesController@offertable')->name('offertable');

Route::get('/getpricejson', 'salesController@getpricejson')->name('getpricejson');

Route::post('/deleteoffer/{ids}', 'salesController@deleteoffer')->name('deleteoffer');


Route::post('/insertofferpaid', 'salesController@insertofferpaid')->name('insertofferpaid');


Route::post('/getselectpriceshow', 'salesController@getselectpriceshow')->name('getselectpriceshow');


Route::get('/bill1/{id}', 'salesController@bill1')->name('bill1');

Route::get('/bill2/{id}', 'salesController@bill2')->name('bill2');


//account 





Route::get('/accountbanksele', 'accountbankController@accountbanksele')->name('accountbanksele');



Route::get('/editaccount3/{sub_account3}', 'accountbankController@editaccount3')->name('editaccount3');




Route::get('/editaccount4/{sub_account4}', 'accountbankController@editaccount4')->name('editaccount4');



Route::post('/update4/{sub_account4}', 'accountbankController@update4')->name('update4');


Route::post('/update3/{sub_account3}', 'accountbankController@update3')->name('update3');





Route::get('/createdaily_entry', 'daily_entryController@create')->name('daily_entrytable');


Route::post('/daily_entryinsert', 'daily_entryController@insert')->name('daily_entryinsert');

    
Route::post('/deleteacreateccountbank1/{accountbank}', 'accountbankController@delete1')->name('deleteaccountbankController1');

Route::post('/deleteacreateccountbank2/{subaccount1}', 'accountbankController@delete2')->name('deleteaccountbankController2');

Route::post('/deleteacreateccountbank3/{sub_account3}', 'accountbankController@delete3')->name('deleteaccountbankController3');

Route::post('/deleteacreateccountbank4/{sub_account4}', 'accountbankController@delete4')->name('deleteaccountbankController4');

Route::post('/updateacc/{accountbank}', 'accountbankController@updateacc')->name('updateacc');


    Route::get('/accountbanktable', 'accountbankController@accountbanktable')->name('accountbanktable');

    Route::get('/accountbankjson', 'accountbankController@accountbankjson')->name('accountbankjson');


Route::get('/createaccountbank', 'accountbankController@accountbankpage')->name('accountbankpage');

Route::post('/createacreateccountbank', 'accountbankController@create')->name('create');


//supplierordercreate



Route::get('/suppilerorderselectright/{id}', 'supplierorderController@supplierorderselectright')->name('suppilerorderselectright');



Route::get('/suppilerorderselectright_edit/{id}', 'supplierorderController@supplierorderselectright_edit')->name('suppilerorderselectright');





//supplierorder Print

Route::get('/supplierorder_Print/{id}', 'supplierorderController@sp_print')->name('sp_print');

Route::get('/supplierorder_count', 'supplierorderController@supplierorder_count')->name('supplierorder_count');


Route::post('/getselectsuppilerorder', 'supplierorderController@getselectsupplierorder')->name('getselectsuppilerorder');

Route::get('/supplierordercreate', 'supplierorderController@supplierordercreate')->name('supplierordercreate');


Route::get('/supplierorderindex', 'supplierorderController@supplierorderindex')->name('supplierorderindex');


Route::get('/supplierorderjson', 'supplierorderController@supplierorderjson')->name('supplierorderjson');


Route::post('/supplierorderinsert', 'supplierorderController@insert')->name('supplierorderinsert');


Route::post('/supplierorderdelete/{ids}', 'supplierorderController@delete')->name('supplierorderdelete');

Route::post('/updatesupplierorder/{supplierorder}', 'supplierorderController@updatesupplierorder')->name('updatesupplierorder');




//pricing_supplier


Route::get('/pricing_supplieredit/{id}', 'pricing_supplierController@edit')->name('pricing_supplieredit');



Route::get('/pricing_supplierindex', 'pricing_supplierController@index')->name('pricing_supplierindex');



Route::get('/pricing_suppliercreate', 'pricing_supplierController@create')->name('pricing_suppliercreate');



Route::get('/pricing_supplierjson', 'pricing_supplierController@pricing_supplierjson')->name('pricing_supplierjson');

Route::POST('/pricing_supplierselect', 'pricing_supplierController@pricing_supplierselect')->name('pricing_supplierselect');

Route::get('/pricing_supplierselectright/{id}', 'pricing_supplierController@pricing_supplierselectright')->name('pricing_supplierselectright');

Route::get('/ps_print/{id}','pricing_supplierController@ps_print')->name('ps_print');

Route::get('/pricing_supplier_edit/{id}','pricing_supplierController@editee')->name('pricing_supplier_edit');




Route::post('/pricing_supplierinsert', 'pricing_supplierController@insert')->name('pricing_supplierinsert');


Route::post('/pricing_supplierdelete/{ids}', 'pricing_supplierController@delete')->name('pricing_supplierdelete');



Route::post('/pricing_supplierupdate/{id}', 'pricing_supplierController@update')->name('pricing_supplierupdate');






Route::post('/updatesupplierpricing/{pricing_supplier}', 'pricing_supplierController@updatesupplierorder')->name('updatesupplierorder');




//purchase_order

Route::get('/purchase_orderindex', 'purchase_orderController@index')->name('purchase_orderindex');

Route::get('/purchase_orderbill1/{id}', 'purchase_orderController@bill1')->name('purchase_orderbill1');




Route::get('/purchase_ordercreate', 'purchase_orderController@create')->name('purchase_ordercreate');


Route::post('/insertpurchase_order', 'purchase_orderController@insert')->name('purchase_orderins');

Route::get('/purchase_orderjson', 'purchase_orderController@purchase_orderjson')->name('purchase_orderjson');

Route::post('/updatepurchase_order/{purchase_order}', 'purchase_orderController@updatepurchase_order')->name('updatepurchase_order');

Route::post('/deletepurchase_order/{ids}', 'purchase_orderController@delete')->name('deletepurchase_order');


//deliver_bond

Route::get('/deliver_bondindex', 'deliver_bondController@index')->name('deliver_bondindex');

Route::get('/deliver_bondcreate', 'deliver_bondController@create')->name('deliver_bondcreate');

Route::post('/deliver_bondinsert', 'deliver_bondController@insert')->name('deliver_bondinsert');

Route::get('/deliveryjson', 'deliver_bondController@deliveryjson')->name('deliveryjson');

Route::post('/deliver_bonddelete/{ids}', 'deliver_bondController@delete')->name('deliver_delete');

Route::post('/updatesdelivery_bond/{delivery_bond}', 'deliver_bondController@updatesdelivery_bond')->name('updatesdelivery_bond');

Route::get('deliver_bond_print/{ids}','deliver_bondController@get_dp')->name('get_dp');



//receipt

Route::get('/receiptindex', 'receiptController@index')->name('receiptindex');

Route::get('/receiptcreate', 'receiptController@create')->name('receiptcreate');
Route::get('/receiptjson', 'receiptController@receiptjson')->name('receiptjson');



Route::post('/receiptinsert', 'receiptController@insert')->name('receiptinsert');



Route::post('/receiptdelete/{ids}', 'receiptController@delete')->name('receiptdelete');

Route::post('/updatesreceipt/{receipt}', 'receiptController@delete')->name('updatesreceipt');


Route::get('/receipt_print/{id}','receiptController@print_load')->name('print_load');

///branch

Route::get('/indexbranch', 'branchController@index')->name('indexbranch');

Route::get('/createbranch', 'branchController@create')->name('createbranch');

Route::get('/branchjson', 'branchController@branchjson')->name('branchjson');

Route::get('/getbranch/{branch}', 'branchController@getbranch')->name('editgetbranch');




//unit
Route::get('/create-unit', 'UnitController@index')->name('create-unit');

Route::post('/post-unit', 'UnitController@create')->name('post-unit');

Route::get('/unit-table', 'UnitController@table')->name('table-unit');

Route::get('/unit-tablejson', 'UnitController@tablejson')->name('tablejson-table');


Route::post('/unitdelete/{id}', 'UnitController@delete')->name('deleteselectunit');

Route::post('/getselectunit', 'UnitController@getselectunit')->name('getselectunit');


//Terms Routes

Route::Post('getselectterm', 'termController@getselectterm')->name('getselectterm');


Route::get('/create-term', 'termController@index')->name('create-term');

Route::post('/post-term', 'termController@create')->name('post-term');

Route::get('/term-table', 'termController@table')->name('table-term');

Route::get('/term-tablejson', 'termController@tablejson')->name('tablejson-term');







Route::post('/branchdelete/{ids}', 'branchController@delete')->name('branchdelete');

Route::post('/branchinsert', 'branchController@branchinsert')->name('branchinsert');

Route::post('/updatebranch/{branch}', 'branchController@updatebranch')->name('updatebranch');



Route::get('/branchselect', 'branchController@branchselect')->name('branchselect');




Route::get('/stock_movementindex', 'stock_movementController@index')->name('stock_movementindex');

Route::get('/stock_movementcreate', 'stock_movementController@create')->name('stock_movementcreate');

Route::post('/stock_movementinsert', 'stock_movementController@insert')->name('stock_movementinsert');


Route::post('/stock_movementdelete/{ids}', 'stock_movementController@delete')->name('stock_movementdelete');



Route::get('/jsonstocck', 'stock_movementController@jsonstocck')->name('jsonstocck');

//easy_restriction
Route::get('/selecteasyeasy_entries', 'easy_restrictionController@select')->name('jsons656tocck');

Route::get('/home_entries', 'easy_restrictionController@pagesay')->name('pagesay');

Route::post('/homejson', 'easy_restrictionController@homejson')->name('homejson');

Route::get('/productfixed0saccount', 'easy_restrictionController@productfixed0saccount')->name('productfixed0saccount');
Route::get('/producteleingsaccount', 'easy_restrictionController@producteleingsaccount')->name('producteleingsaccount');







Route::get('/moneymovement_entries', 'easy_restrictionController@moneymovements')->name('moneymovements');




Route::get('/moneymovementsaccount', 'easy_restrictionController@moneymovementsaccount')->name('moneymovementsaccount');

Route::get('/moneycapitalsaccount', 'easy_restrictionController@moneycapitalsaccount')->name('moneycapitalsaccount');

Route::get('/moneycapital2saccount', 'easy_restrictionController@moneycapital2saccount')->name('moneycapital2saccount');



Route::get('/capital_entries', 'easy_restrictionController@moneycapital')->name('moneycapital');



Route::get('/fixedsaccount', 'easy_restrictionController@fixedsaccount')->name('fixedsaccount');


Route::get('/Fixedasset_entries', 'easy_restrictionController@Fixedasset')->name('Fixedasset');



Route::get('/fixed0saccount', 'easy_restrictionController@fixed0saccount')->name('fixed0saccount');

Route::get('/withdraw_entries', 'easy_restrictionController@withdraw')->name('withdraw');


Route::get('/distributeprofits', 'easy_restrictionController@distributeprofits')->name('distributeprofits');


Route::get('/distributeprofits_entries', 'easy_restrictionController@profits')->name('profits');

Route::get('/payrollaccounting_entries', 'easy_restrictionController@payrollaccounting')->name('payrollaccounting_entries');

Route::get('/payrollaccountinga', 'easy_restrictionController@payrollaccountinga')->name('payrollaccountinga');




Route::post('/easymovementpost', 'easy_restrictionController@easymovement')->name('easymovementeasymovement');

Route::post('/editeasymovement/{easy_restriction}', 'easy_restrictionController@editeasymovement')->name('editeasymovement');


Route::post('/deleteeasymovement/{easy_restriction}', 'easy_restrictionController@delete')->name('deleteeasymovement');




Route::get('/daily_entry/{easy_restriction}', 'easy_restrictionController@spicesay')->name('spicesay');


Route::get('/easy_entryedit/{easy_restriction}', 'easy_restrictionController@moneymovementsedit')->name('moneymovementsedit.edit');



Route::get('/print_esay_entry/{easy_restriction}', 'easy_restrictionController@spiceasy')->name('moneymovementsedit.spiceasy');




//opening_credit



Route::get('/opening_credit_product', 'opening_creditController@createproduct')->name('opening_credit.createproduct');


Route::get('/customer_opening_credit', 'opening_creditController@createpage')->name('createopening_credit');
Route::post('/createopening_credit_insarting', 'opening_creditController@insarting')->name('createopening_credit.insarting');


Route::get('/createopening_credit_accounting', 'opening_creditController@createaccounting')->name('opening_credit.createaccounting');

Route::get('/opening_credit_select', 'opening_creditController@select')->name('opening_credit.select');


Route::get('/allaccount', 'opening_creditController@allaccount')->name('opening_credit.allaccount');


Route::get('/opening_credit_createsuppiler', 'opening_creditController@createsuppiler')->name('opening_credit.createsuppiler');


Route::get('/opening_credit', 'opening_creditController@index')->name('index.entry_manuale');


Route::post('/opening_credit_homejson', 'opening_creditController@homejson')->name('opening_credit.homejson');



Route::get('/opening_credit_edit/{entry_manual}', 'opening_creditController@editpage')->name('opening_credit.edit');

Route::get('/review/{entry_manual}', 'opening_creditController@printentry')->name('printentry.edit');




Route::post('/opening_credit_update/{entry_manual}', 'opening_creditController@update')->name('opening_credit.update');

Route::post('/opening_credit_delete/{entry_manual}', 'opening_creditController@delete')->name('opening_credit.delete');


//role

Route::get('/addrole', 'addroleController@addrole')->name('addrole');

Route::get('/indexrole', 'addroleController@indexrole')->name('indexrole');



Route::get('/rolejjson', 'addroleController@rolejjson')->name('rolejjson');



Route::get('/rolejedit/{role}', 'addroleController@rolejedit')->name('rolejedit');

Route::post('/updaterole/{role}', 'addroleController@updaterole')->name('updaterole');






Route::post('/insertrole', 'addroleController@insert')->name('insertinsert');



//manule

Route::get('/createmanule', 'manuleController@manulepage')->name('manule.create');



Route::get('/createuser', 'subscriptionController@create')->name('create.users');

Route::get('/subscriptionjson', 'subscriptionController@subscriptionjson')->name('subscriptionjson.users');


Route::get('/subscriptiontable', 'subscriptionController@subscription')->name('subscriptionjson.subscription');

Route::get('/subscriptionedit/{user}', 'subscriptionController@edit')->name('edit.subscription');

Route::post('/subscriptionupdate/{user}', 'subscriptionController@update')->name('update.subscription');




Route::post('/insrtinguser', 'subscriptionController@inserting')->name('insertingsub');



///reports

Route::post('/ledger', 'ledgercontroller@ledger')->name('ledger');


Route::get('/trial_balances', 'ledgercontroller@trial_balances')->name('trial_balances');

Route::get('/Balance_Sheet', 'ledgercontroller@Balance_Sheet')->name('Balance_Sheet');


Route::get('/Journal_Reports', 'ledgercontroller@Journal_Reports')->name('Journal_Reports');


Route::post('/easy_restriction_json', 'ledgercontroller@easy_restriction_json')->name('easy_restriction_json');

Route::post('/manule_entry_json', 'ledgercontroller@easy_entry_json')->name('easy_entry_json');


Route::get('/ledgerpage', 'ledgercontroller@ledgerpage')->name('ledgerpage');

Route::get('/report_tax', 'ledgercontroller@tax')->name('report.tax');
Route::post('/report_purchase_order', 'ledgercontroller@purchase_order')->name('report.purchase_order');

Route::get('/sales_and_purchasesreport', 'ledgercontroller@sales_and_purchasesreport')->name('report.sales_and_purchasesreport');

Route::post('/sales_invoicesjson', 'ledgercontroller@sales_invoicesjson')->name('report.sales_invoicesjson');

Route::get('/sales_invoices', 'ledgercontroller@sales_invoices')->name('report.sales_invoices');



Route::post('/ar_by_customersjson', 'ledgercontroller@ar_by_customersjson')->name('report.ar_by_customersjson');

Route::get('/ar_by_customers', 'ledgercontroller@ar_by_customers')->name('report.ar_by_customers');

Route::post('/ap_by_vendorsjson', 'ledgercontroller@ap_by_vendorsjson')->name('report.ap_by_vendorsjson');

Route::get('/ap_by_vendors', 'ledgercontroller@ap_by_vendors')->name('report.ap_by_vendors');

Route::get('/report/Account_Summary', 'ledgercontroller@SummaryAccount')->name('report.SummaryAccount');


Route::post('/report/purchase_orderjson', 'ledgercontroller@purchase_orderjson')->name('report.purchase_orderjson');
Route::get('/report/purchase_order', 'ledgercontroller@purchase_orderchart')->name('report.purchase_order');

Route::get('/report/homepage', 'ledgercontroller@homepage')->name('report.homepage');



Route::post('/ledger2', 'ledgercontroller@ledger2')->name('report.ledger2');




Route::post('/sales_and_purchases', 'ledgercontroller@sales_and_purchases')->name('report.sales_and_purchases');




Route::post('/taxreportjson', 'ledgercontroller@taxreportjson')->name('report.taxreportjson');


Route::get('/taxreport', 'ledgercontroller@taxreport')->name('report.taxreport');


Route::get('/productcharts', 'ledgercontroller@productcharts')->name('report.productcharts');



Route::post('/productchartsjson', 'ledgercontroller@productchartsjson')->name('report.productchartsjson');







//cashier

Route::get('/cashier/{branch}', 'cashierController@index')->name('cashier.index');




Route::get('/closeshift/{shift}', 'cashierController@closeshift')->name('cashier.closeshift');

Route::get('/checkshift/{shift}', 'cashierController@checkshift')->name('cashier.checkshift');


Route::get('/invcashier/{checkoutcashier}', 'cashierController@invcashier')->name('cashier.invcashier');

Route::get('/getcategories', 'cashierController@getcategories')->name('cashier.getcategories');

     

Route::get('/getcart', 'cashierController@getcart')->name('cashier.getcart');



Route::get('/getproductcashier/{category}', 'cashierController@getproduct')->name('cashier.getproduct');

Route::post('/cart', 'cashierController@cart')->name('cashier.cart');

Route::post('/cartupdate/{cart}', 'cashierController@updatecart')->name('cashier.cartupdate');

Route::post('/cartdelete/{cart}', 'cashierController@delete')->name('cashier.cartdelete');

Route::get('/checkoutcashier/{branch}', 'cashierController@checkout')->name('cashier.checkout');


Route::post('/startshift/{branch}', 'cashierController@startshift')->name('cashier.startshift');


Route::get('/paycashier', 'cashierController@pay')->name('cashier.pay');





Route::get('/pay_cash', 'cashierController@cash')->name('cashier.cash');




Route::get('/deliver_bond_print',function(){

    return  view('print.deliverybonds')->with(['data'=>'20']);



});



//Edit handling            

Route::get('/offeredit/{id}','salesController@getselectpriceshow_edit')->name('getselectpriceshow_edit');


