<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>bill</title>
    <!-- font google  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap"
        rel="stylesheet">
    <!-- bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <!-- main css -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets2/css/style.css')); ?>">
    <!--bill css-->
    <link rel="stylesheet" href="<?php echo e(asset('/assets2/css/bill/bill.css')); ?>">
</head>

<body dir="rtl">
    <div class="container-fluid">
        <div class="container">
            <div class="title-bill text-center mt-5">
                <h5>فاتوره </h5>
                <p> رقم الفاتوره <b>#<?php echo e($data->id); ?></b></p>
            </div>
            <div class="row mt-5 flex-column text-center align-items-center">
                <div class="col-3">
                    <div class="title-name-seller">
                        <h5>اسم التاجر</h5>
                    </div>
                </div>
                <div class="col-3">
                    <div class="title-idress-seller">
                        <h5>عنوان المتجر</h5>
                    </div>
                </div>
            </div>
            <div class="row mt-5 justify-content-center">
                <div class="col-4">
                    <div class="date" style="width: 220px;">
                        <h5>التاريخ : <small><?php echo e($data->created_at->format('j F, Y')); ?></small></h5>
                    </div>
                    <div class="date " style="width:330px">
                        <h5>الرقم الضريبي : <small><?php echo e($data->taxnum); ?></small></h5>
                    </div>
                </div>
                <div class="col-2">
                    <div class="time p-4">
                        <h5>الوقت : 14 20 :25</h5>
                    </div>
                </div>

            </div>

            <div class="row mt-3">
                <div class="col-6 m-auto" style="border: 1px solid #102051; border-radius: 10px;">
                    <table class="table table-bill-two">
                        <thead>
                            <tr>
                                <th scope="col" colspan="3">المنتجات</th>
                                <th scope="col" style="width: 50px;">الكميه</th>
                                <th scope="col" style="width: 50px;">السعر</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td colspan="3"><?php echo e($v->name); ?></td>
                                <td><?php echo e($v->pivot->quantity); ?></td>
                                <td><?php echo e($v->selling * $v->pivot->quantity); ?></td>
                            </tr>
                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 

                        </tbody>
                        <tfoot>
                            <tr>
                                <td>المجموع (الريال)</td>
                                
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><?php echo e($data->total_amount); ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="row mt-3 justify-content-center">
                <div class="col-6">
                    <div class="tax">
                        <h6> يشمل ضريبة القيمة المضافة (15%) </h6>
                        <h6><?php echo e($data->overall); ?></h6>
                    </div>
                </div>
            </div>
            <div class="row mt-4 justify-content-center text-center">
    
                <div class="col-3">
                    <h5>اغلاق الفاتورة 01550</h5>
                </div>
               
                <div class="w-100"></div>
                <div class="col-2 mt-3">
                    <div class="qr">
                        <img src="../../assets/img/icon/qr.png" alt="qr">
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>

</html><?php /**PATH D:\development\smartcashier\resources\views/bill/bill2.blade.php ENDPATH**/ ?>